## 解题思路：

设跳上 $n$ 级台阶有 $f(n)$ 种跳法。在所有跳法中，青蛙的最后一步只有两种情况： **跳上 $1$ 级或 $2$ 级台阶**。

1. **当为 $1$ 级台阶：** 剩 $n-1$ 个台阶，此情况共有 $f(n-1)$ 种跳法。
2. **当为 $2$ 级台阶：** 剩 $n-2$ 个台阶，此情况共有 $f(n-2)$ 种跳法。

即 $f(n)$ 为以上两种情况之和，即 $f(n)=f(n-1)+f(n-2)$ ，以上递推性质为斐波那契数列。因此，本题可转化为 **求斐波那契数列的第 $n$ 项**，区别仅在于初始值不同：

- 青蛙跳台阶问题： $f(0)=1$ ,  $f(1)=1$ , $f(2)=2$ 。
- 斐波那契数列问题： $f(0)=0$ , $f(1)=1$ , $f(2)=1$ 。

![Picture1.png](https://pic.leetcode-cn.com/1599883153-UckfTw-Picture1.png){:width=500}

### 动态规划解析：

- **状态定义：** 设 $dp$ 为一维数组，其中 $dp[i]$ 的值代表斐波那契数列的第 $i$ 个数字。
- **转移方程：** $dp[i + 1] = dp[i] + dp[i - 1]$ ，即对应数列定义 $f(n + 1) = f(n) + f(n - 1)$ 。
- **初始状态：** $dp[0] = 1$, $dp[1] = 1$ ，即初始化前两个数字。
- **返回值：** $dp[n]$ ，即斐波那契数列的第 $n$ 个数字。

### 状态压缩：

若新建长度为 $n$ 的 $dp$ 列表，则空间复杂度为 $O(N)$ 。

由于 $dp$ 列表第 $i$ 项只与第 $i-1$ 和第 $i-2$ 项有关，因此只需要初始化三个整形变量 `sum`, `a`, `b` ，利用辅助变量 $sum$ 使 $a, b$ 两数字交替前进即可 *（具体实现见代码）* 。由于省去了 $dp$ 列表空间，因此空间复杂度降至 $O(1)$ 。

## 代码：

```Python []
class Solution:
    def climbStairs(self, n: int) -> int:
        a, b = 1, 1
        for _ in range(n - 1):
            a, b = b, a + b
        return b
```

```Java []
class Solution {
    public int climbStairs(int n) {
        int a = 1, b = 1, sum;
        for(int i = 0; i < n - 1; i++){
            sum = a + b;
            a = b;
            b = sum;
        }
        return b;
    }
}
```

```C++ []
class Solution {
public:
    int climbStairs(int n) {
        int a = 1, b = 1, sum;
        for(int i = 0; i < n - 1; i++){
            sum = a + b;
            a = b;
            b = sum;
        }
        return b;
    }
};
```

### 复杂度分析：

- **时间复杂度 $O(n)$ ：** 计算 $f(n)$ 需循环 $n$ 次，每轮循环内计算操作使用 $O(1)$ 。
- **空间复杂度 $O(1)$ ：** 几个标志变量使用常数大小的额外空间。
